/*
 * Decompiled with CFR 0.152.
 */
package com.technicalitiesmc.lib.network;

import com.technicalitiesmc.lib.block.RotationHandler;
import com.technicalitiesmc.lib.block.TKBlock;
import com.technicalitiesmc.lib.network.Packet;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Rotation;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraftforge.network.NetworkEvent;

public class ServerboundRotateBlockPacket
implements Packet {
    private final BlockPos pos;
    private final Direction.Axis axis;
    private final Rotation rotation;

    public ServerboundRotateBlockPacket(BlockPos pos, Direction.Axis axis, Rotation rotation) {
        this.pos = pos;
        this.axis = axis;
        this.rotation = rotation;
    }

    public ServerboundRotateBlockPacket(FriendlyByteBuf buf) {
        this.pos = buf.m_130135_();
        this.axis = (Direction.Axis)buf.m_130066_(Direction.Axis.class);
        this.rotation = (Rotation)buf.m_130066_(Rotation.class);
    }

    @Override
    public void encode(FriendlyByteBuf buf) {
        buf.m_130064_(this.pos);
        buf.m_130068_((Enum)this.axis);
        buf.m_130068_((Enum)this.rotation);
    }

    @Override
    public boolean handle(NetworkEvent.Context context) {
        context.enqueueWork(() -> {
            ServerPlayer player = context.getSender();
            ServerLevel level = player.m_183503_();
            BlockState state = level.m_8055_(this.pos);
            RotationHandler rotationHandler = TKBlock.getInterface(state.m_60734_(), RotationHandler.class);
            if (rotationHandler != null) {
                rotationHandler.rotate(state, (Level)level, this.pos, this.axis, this.rotation);
            }
        });
        return true;
    }
}

